/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CFile.h,v 1.4 2000/05/13 06:34:20 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CFile_h	// [
#define Included_CFile_h

#include "pgpClassesConfig.h"
#include "CPFLImpFactory.h"

_PGP_BEGIN

// Class CFile

class CFile SMART_ERROR_INHERIT
{
	NOT_COPYABLE(CFile)
	DECLARE_IMPHOST(CFile)

public:
	enum
	{
		kNoFlags			= 0x0000, 
		kReadOnlyFlag		= 0x0001, 
		kDenyReadFlag		= 0x0002, 
		kShareWriteFlag		= 0x0004, 
		kCreateIfFlag		= 0x0008, 
		kNoBufferingFlag	= 0x0010	// may have restrictions
	};

public:
	PGPBoolean	IsOpened() const;
	PGPBoolean	IsReadOnly() const;
	PGPBoolean	IsVirtualVolume() const;

	const char * Path() const;

#if PGP_EXCEPTIONS
	PGPUInt64	GetLength() const;
	PGPUInt64	GetUniqueFileId() const;
#else	// !PGP_EXCEPTIONS
	CComboError	GetLength(PGPUInt64& length) const;
	CComboError	GetUniqueFileId(PGPUInt64& fileId) const;
#endif	// PGP_EXCEPTIONS

	SMART_ERROR	SetIsCompressed(PGPBoolean isCompressed);
	SMART_ERROR	SetLength(PGPUInt64 length);

	static PGPBoolean	IsFileInUseByReader(const char *path);
	static PGPBoolean	IsFileInUseByWriter(const char *path);
	static PGPBoolean	IsFileInUse(const char *path);

	void	Flush();

	SMART_ERROR	Open(const char *path, PGPUInt32 flags = kNoFlags);
	SMART_ERROR	Close();
	SMART_ERROR	Delete(const char *path);
	SMART_ERROR	Move(const char *oldPath, const char *newPath);

	SMART_ERROR	Read(void *buf, PGPUInt64 pos, 
		PGPUInt32 nBytes) const;
	SMART_ERROR	Write(const void *buf, PGPUInt64 pos, 
		PGPUInt32 nBytes) const;
};

_PGP_END

#endif	// ] Included_CFile_h
